//macneil
//codeforces meowcneil

#pragma GCC optimize("O2")
#pragma GCC optimize("unroll-loops")

#include <bits/stdc++.h>
#include <ext/pb_ds/tree_policy.hpp>
#include <ext/pb_ds/assoc_container.hpp>

using namespace std;
using namespace __gnu_pbds;

//#define int long long
#define all(a) a.begin(), a.end()
#define rall(a) a.rbegin(), a.rend()
#define f(n) for(int i = 0; i < n; ++i)
#define ordered_set tree<int, null_type, less<int>, rb_tree_tag, tree_order_statistics_node_update>

typedef long long ll;
typedef long double ld;
typedef vector<int> vei;

struct SparseTable {
    vector<vector<int>> sp;
    vector<int> a;

    SparseTable(vector<int> a) : a(a) {
        int n = a.size();
        sp.resize(log2(n)+1, vei(n));
        f(n) sp[0][i] = i;
        for(int i = 1; i < sp.size(); ++i) {
            for(int j = 0; j < n; ++j) {
                int i2 = min(n-1, j+(1<<(i-1)));
                if(a[sp[i-1][j]] < a[sp[i-1][i2]]) sp[i][j] = sp[i-1][j];
                else sp[i][j] = sp[i-1][i2];
            }
        }
    }

    int get_min(int l, int r) { //[r, l)
        int lg = log2(r - l);
        int t = r - (1<<lg);
        if(a[sp[lg][l]] < a[sp[lg][t]]) return sp[lg][l];
        return sp[lg][t];
    }
};

struct Fenwick {
    vector<int> tr;
    vector<int> a;
    int n;

    Fenwick(int n) : n(n) {
        tr.resize(n+1);
        a.resize(n+1);
    }

    void add(int i, int x) {
        a[i] += x;
        for(; i <= n; i += i&(-i)) {
            tr[i] += x;
        }
    }

    void set(int i, int x) {
        x = x - a[i];
        for(; i <= n; i += i&(-i)) {
            tr[i] += x;
        }
        a[i] += x;
    }

    int gts(int i) {
        int an = 0;
        for(; i > 0; i -= i&(-i)) {
            an += tr[i];
        }
        return an;
    }

    int gt(int l, int r) {
        return gts(r+1) - gts(l);
    }
};

struct SegTree {
    struct Node {

        Node() {}

    };
    vector<Node> tr;
    int sz;

    Node merge(Node a, Node b) {

    }

    SegTree(vector<int> a) {
        int n = a.size();
        sz = (1ll<<((ll)log2(n)+1));
        tr.resize(2*sz);
        for(int i = 0; i < n; ++i) {
            tr[i+sz-1] = {};
        }
        for(int i = sz - 2; i >= 0; --i) tr[i] = merge(tr[2*i+1], tr[2*i+2]);
    }

    void update(int v, int l, int r, int ind, Node x) {
        if(r == l + 1) {
            tr[v] = x;
            return;
        }
        int m = (r + l) / 2;
        if(ind < m) update(2*v+1, l, m, ind, x);
        else update(2*v+2, m, r, ind, x);
        tr[v] = merge(tr[v*2+1], tr[v*2+2]);
    }

    void update(int ind, Node x) {
        update(0, 0, sz, ind, x);
    }

    Node get(int v, int l, int r, int ql, int qr) {
        if(l <= ql && qr <= r) return tr[v];
        if(l >= qr || r <= ql) {
            Node tmp;
            return tmp;
        }
        int m = (r + l) / 2;
        return merge(get(2*v+1, l, m, ql, qr), get(2*v+2, m, r, ql, qr));
    }

    Node get(int l, int r) {
        return get(0, 0, sz, l, r);
    }
};


void solve() {
    int x, y;
    cin>>x>>y;
    int t = y - x;
    if(t==0) {
        cout<<0<<'\n';
        return;
    }
    int ans = x-1;
    for(int i = 1; i * i <= t; ++i) {
        if(t%i==0) {
            int k = i;
            if(k <= x) ans = min(ans, x - k);
            k = t / i;
            if(k <= x) ans = min(ans, x - k);
        }
    }
    cout<<ans<<'\n';
}

signed main() {
    ios_base::sync_with_stdio(0);
    cin.tie(0);cout.tie(0);

    int tc = 1;
     cin >> tc;
    for(int i = 0; i < tc; ++i) {
        solve();
    }
}